<?php
/**
 * The template part for header
 *
 * @package VW Photography 
 * @subpackage vw_photography
 * @since VW Photography 1.0
 */
?>

<?php
  $vw_photography_search_hide_show = get_theme_mod( 'vw_photography_search_hide_show' );
  if ( 'Disable' == $vw_photography_search_hide_show ) {
   $colmd = 'col-lg-4 col-md-4';
  } else { 
   $colmd = 'col-lg-4 col-md-4';
  } 
?>

<div id="header">
  <div class="header-menu <?php if( get_theme_mod( 'vw_photography_sticky_header', false) != '' || get_theme_mod( 'vw_photography_stickyheader_hide_show', false) != '') { ?> header-sticky"<?php } else { ?>close-sticky <?php } ?>">
    <div class="container">
      <div class="bg-header-box">
        <div class="row">
          <div class="col-lg-4 col-md-4 align-self-center">
            <div class="nav primary-left">
              <div id="mySidenav" class="nav sidenav">
                <nav id="site-navigation" class="main-navigation" role="navigation" aria-label="<?php esc_attr_e( 'Top Menu', 'vw-photography' ); ?>">
                  <?php 
                    if(has_nav_menu('primary-left')){
                      wp_nav_menu( array( 
                        'theme_location' => 'primary-left',
                        'container_class' => 'main-menu clearfix' ,
                        'menu_class' => 'clearfix',
                        'items_wrap' => '<ul id="%1$s" class="%2$s mobile_nav">%3$s</ul>',
                        'fallback_cb' => 'wp_page_menu',
                      ) ); 
                    }
                  ?>
                  <a href="javascript:void(0)" class="closebtn mobile-menu" onclick="vw_photography_menu_close_nav()"><i class="fas fa-times"></i><span class="screen-reader-text"><?php esc_html_e('Close Button','vw-photography'); ?></span></a>
                </nav>
              </div>
            </div>
          </div>
          <div class="col-lg-3 col-md-4 align-self-center">
            <div class="logo">
              <?php if ( has_custom_logo() ) : ?>
                <div class="site-logo"><?php the_custom_logo(); ?></div>
              <?php endif; ?>
              <?php $blog_info = get_bloginfo( 'name' ); ?>
                <?php if ( ! empty( $blog_info ) ) : ?>
                  <?php if ( is_front_page() && is_home() ) : ?>
                    <?php if( get_theme_mod('vw_photography_logo_title_hide_show',true) != ''){ ?>
                      <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
                    <?php } ?>
                  <?php else : ?>
                    <?php if( get_theme_mod('vw_photography_logo_title_hide_show',true) != ''){ ?>
                      <p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
                    <?php } ?>
                  <?php endif; ?>
                <?php endif; ?>
                <?php
                  $description = get_bloginfo( 'description', 'display' );
                  if ( $description || is_customize_preview() ) :
                ?>
                <?php if( get_theme_mod('vw_photography_tagline_hide_show',true) != ''){ ?>
                  <p class="site-description">
                    <?php echo esc_html($description); ?>
                  </p>
                <?php } ?>
              <?php endif; ?>
            </div>
          </div>
          <div class="<?php echo esc_html( $colmd ); ?> align-self-center">
            <div class="nav primary-right">
              <div id="mySidenav" class="nav sidenav">
                <nav id="site-navigation" class="main-navigation" role="navigation" aria-label="<?php esc_attr_e( 'Top Menu', 'vw-photography' ); ?>">
                  <?php
                    if(has_nav_menu('primary-right')){
                      wp_nav_menu( array( 
                        'theme_location' => 'primary-right',
                        'container_class' => 'main-menu clearfix' ,
                        'menu_class' => 'clearfix',
                        'items_wrap' => '<ul id="%1$s" class="%2$s mobile_nav">%3$s</ul>',
                        'fallback_cb' => 'wp_page_menu',
                      ) ); 
                    }
                  ?>
                  <a href="javascript:void(0)" class="closebtn mobile-menu" onclick="vw_photography_menu_close_nav()"><i class="fas fa-times"></i><span class="screen-reader-text"><?php esc_html_e('Close Button','vw-photography'); ?></span></a>
                </nav>
              </div>
            </div>
          </div>
          <?php if ( 'Disable' != $vw_photography_search_hide_show ) {?>
            <div class="search-box col-lg-1 col-md-12 align-self-center">
              <span><a href="#"><i class="<?php echo esc_attr(get_theme_mod('vw_photography_search_icon','fas fa-search')); ?>"></i></a></span>
            </div>
          <?php } ?>
        </div>
      </div>
    </div>
    <div class="serach_outer">
      <div class="closepop"><a href="#maincontent"><i class="<?php echo esc_attr(get_theme_mod('vw_photography_search_close_icon','fa fa-window-close')); ?>"></i></a></div>
      <div class="serach_inner">
        <?php get_search_form(); ?>
      </div>
    </div>
  </div>
</div>