<?php
/**
 * Template Name: Custom Home
 */

get_header(); ?>

<main id="maincontent" role="main">
  <?php do_action( 'vw_photography_before_slider' ); ?>

  <?php if( get_theme_mod( 'vw_photography_slider_hide_show', false) != '' || get_theme_mod( 'vw_photography_resp_slider_hide_show', false) != '') { ?>
    <section id="slider">
      <div id="carouselExampleCaptions" class="carousel slide" data-bs-ride="carousel" data-bs-interval="<?php echo esc_attr(get_theme_mod( 'vw_photography_slider_speed',4000)) ?>">
        <?php $vw_photography_slider_pages = array();
          for ( $count = 1; $count <= 4; $count++ ) {
            $mod = intval( get_theme_mod( 'vw_photography_slider_page' . $count ));
            if ( 'page-none-selected' != $mod ) {
              $vw_photography_slider_pages[] = $mod;
            }
          }
          if( !empty($vw_photography_slider_pages) ) :
            $args = array(
              'post_type' => 'page',
              'post__in' => $vw_photography_slider_pages,
              'orderby' => 'post__in'
            );
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) :
              $i = 1;
        ?>     
        <div class="carousel-inner" role="listbox">
          <?php  while ( $query->have_posts() ) : $query->the_post(); ?>
            <div <?php if($i == 1){echo 'class="carousel-item active"';} else{ echo 'class="carousel-item"';}?>>
              <?php the_post_thumbnail(); ?>
              <div class="carousel-caption">
                <div class="inner_carousel">
                  <h1><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h1>
                  <p><?php $excerpt = get_the_excerpt(); echo esc_html( vw_photography_string_limit_words( $excerpt, esc_attr(get_theme_mod('vw_photography_slider_excerpt_number','30')))); ?></p>
                  <?php if( get_theme_mod('vw_photography_slider_button_text','READ MORE') != ''){ ?>
                    <a class="more-btn" href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_html(get_theme_mod('vw_photography_slider_button_text',__('READ MORE','vw-photography')));?><span class="screen-reader-text"><?php echo esc_html(get_theme_mod('vw_photography_slider_button_text',__('READ MORE','vw-photography')));?></span></a>
                  <?php } ?>
                </div>
              </div>
            </div>
          <?php $i++; endwhile; 
          wp_reset_postdata();?>
        </div>
        <?php else : ?>
        <div class="no-postfound"></div>
        <?php endif;
        endif;?>
        <a class="carousel-control-prev" data-bs-target="#carouselExampleCaptions" data-bs-slide="prev" role="button">
          <span class="carousel-control-prev-icon w-auto h-auto" aria-hidden="true"><i class="fas fa-chevron-left"></i></span>
          <span class="screen-reader-text"><?php esc_html_e( 'Previous','vw-photography' );?></span>
        </a>
        <a class="carousel-control-next" data-bs-target="#carouselExampleCaptions" data-bs-slide="next" role="button">
          <span class="carousel-control-next-icon w-auto h-auto" aria-hidden="true"><i class="fas fa-chevron-right"></i></span>
          <span class="screen-reader-text"><?php esc_html_e( 'Next','vw-photography' );?></span>
        </a>
      </div>  
      <div class="clearfix"></div>
    </section>
  <?php } ?>

  <?php do_action( 'vw_photography_after_slider' ); ?>

  <?php if( get_theme_mod( 'vw_photography_category_page') != '') { ?>
    <section id="photo-category">
      <div class="container">
        <div class="row m-0">
          <div class="col-lg-3 col-md-12">
            <?php $photo_category_pages = array();
              $mod = absint( get_theme_mod( 'vw_photography_category_page','vw-photography'));
              if ( 'page-none-selected' != $mod ) {
                $photo_category_pages[] = $mod;
              }
              if( !empty($photo_category_pages) ) :
                $args = array(
                  'post_type' => 'page',
                  'post__in' => $photo_category_pages,
                  'orderby' => 'post__in'
                );
                $query = new WP_Query( $args );
                if ( $query->have_posts() ) :
                  $count = 0;
                  while ( $query->have_posts() ) : $query->the_post(); ?>
                    <div class="cat-page-box">
                      <i class="<?php echo esc_attr(get_theme_mod('vw_photography_category_page_icon','fas fa-camera-retro')); ?>"></i><h2><?php the_title(); ?></h2>
                      <p><?php $excerpt = get_the_excerpt(); echo esc_html( vw_photography_string_limit_words( $excerpt, esc_attr(get_theme_mod('vw_photography_category_excerpt_number','30')))); ?></p>
                      <a href="<?php echo esc_url(get_permalink()); ?>"><?php esc_html_e('View all Categories','vw-photography'); ?><span class="screen-reader-text"><?php esc_html_e( 'View all Categories','vw-photography' );?></span></a>
                    </div>
                  <?php $count++; endwhile; ?>
                <?php else : ?>
                  <div class="no-postfound"></div>
                <?php endif;
              endif;
              wp_reset_postdata()
            ?>
          </div>
          <div class="col-lg-9 col-md-12 p-0">
            <div class="row">
              <?php 
                for ( $vw_photography_m = 1; $vw_photography_m <= 3; $vw_photography_m++ ) {
                  $args = array( 'name' => get_theme_mod('vw_photography_post_category'.$vw_photography_m));
                    $query = new WP_Query( $args );
                    if ( $query->have_posts() ) :
                      while ( $query->have_posts() ) : $query->the_post(); ?>
                        <div class="cat_content  col-lg-4 col-md-4 p-0">
                          <div class="cat-posts">
                            <?php the_post_thumbnail(); ?>
                            <div class="cat_body">
                              <h3><?php the_title(); ?></h3>
                              <span class="entry-date"><?php echo get_the_date(); ?></span>
                              <p><?php $excerpt = get_the_excerpt(); echo esc_html( vw_photography_string_limit_words( $excerpt, esc_attr(get_theme_mod('vw_photography_category_excerpt_number','30')))); ?></p>
                              <?php if( get_theme_mod('vw_photography_category_button_text','Read More') != ''){ ?>
                                <a class="theme_button" href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_html(get_theme_mod('vw_photography_category_button_text',__('Read More','vw-photography')));?><span class="screen-reader-text"><?php echo esc_html(get_theme_mod('vw_photography_category_button_text',__('Read More','vw-photography')));?></span></a>
                              <?php } ?>
                            </div>
                          </div>
                          <h3 class="title-btn"><?php the_title(); ?></h3>
                        </div>
                      <?php endwhile;
                      wp_reset_postdata();?>
                      <?php else : ?>
                        <div class="no-postfound"></div>
                      <?php
                  endif; 
              } ?>
            </div>
          </div>
        </div>
      </div>
    </section>
  <?php } ?>

  <?php do_action( 'vw_photography_after_photography_category' ); ?>

  <div class="content-vw">
    <div class="container">
      <?php while ( have_posts() ) : the_post(); ?>
        <?php the_content(); ?>
      <?php endwhile; // end of the loop. ?>
    </div>
  </div>
</main>

<?php get_footer(); ?>