<?php
//about theme info
add_action( 'admin_menu', 'vw_photography_gettingstarted' );
function vw_photography_gettingstarted() {    	
	add_theme_page( esc_html__('About VW Photography', 'vw-photography'), esc_html__('About VW Photography', 'vw-photography'), 'edit_theme_options', 'vw_photography_guide', 'vw_photography_mostrar_guide');   
}

// Add a Custom CSS file to WP Admin Area
function vw_photography_admin_theme_style() {
   wp_enqueue_style('vw-photography-custom-admin-style', esc_url(get_template_directory_uri()) . '/inc/getstart/getstart.css');
   wp_enqueue_script('vw-photography-tabs', esc_url(get_template_directory_uri()) . '/inc/getstart/js/tab.js');
   wp_enqueue_style( 'font-awesome-css', esc_url(get_template_directory_uri()).'/css/fontawesome-all.css' );
}
add_action('admin_enqueue_scripts', 'vw_photography_admin_theme_style');

//guidline for about theme
function vw_photography_mostrar_guide() { 
	//custom function about theme customizer
	$return = add_query_arg( array()) ;
	$theme = wp_get_theme( 'vw-photography' );
?>

<div class="wrapper-info">
    <div class="col-left">
    	<h2><?php esc_html_e( 'Welcome to VW Photography Theme', 'vw-photography' ); ?> <span class="version">Version: <?php echo esc_html($theme['Version']);?></span></h2>
    	<p><?php esc_html_e('All our WordPress themes are modern, minimalist, 100% responsive, seo-friendly,feature-rich, and multipurpose that best suit designers, bloggers and other professionals who are working in the creative fields.','vw-photography'); ?></p>
    </div>
    <div class="col-right">
    	<div class="logo">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getstart/images/final-logo.png" alt="" />
		</div>
		<div class="update-now">
			<h4><?php esc_html_e('Buy VW Photography at 20% Discount','vw-photography'); ?></h4>
			<h4><?php esc_html_e('Use Coupon','vw-photography'); ?> ( <span><?php esc_html_e('vwpro20','vw-photography'); ?></span> ) </h4>
			<div class="info-link">
				<a href="<?php echo esc_url( VW_PHOTOGRAPHY_BUY_NOW ); ?>" target="_blank"> <?php esc_html_e( 'Upgrade to Pro', 'vw-photography' ); ?></a>
			</div>
		</div>
    </div>

    <div class="tab-sec">
		<div class="tab">
			<button class="tablinks" onclick="vw_photography_open_tab(event, 'lite_theme')"><?php esc_html_e( 'Setup With Customizer', 'vw-photography' ); ?></button>
			<button class="tablinks" onclick="vw_photography_open_tab(event, 'block_pattern')"><?php esc_html_e( 'Setup With Block Pattern', 'vw-photography' ); ?></button>
			<button class="tablinks" onclick="vw_photography_open_tab(event, 'gutenberg_editor')"><?php esc_html_e( 'Setup With Gutunberg Block', 'vw-photography' ); ?></button>
		  	<button class="tablinks" onclick="vw_photography_open_tab(event, 'theme_pro')"><?php esc_html_e( 'Get Premium', 'vw-photography' ); ?></button>
		  	<button class="tablinks" onclick="vw_photography_open_tab(event, 'free_pro')"><?php esc_html_e( 'Support', 'vw-photography' ); ?></button>
		</div>

		<?php
			$vw_photography_plugin_custom_css = '';
			if(class_exists('Ibtana_Visual_Editor_Menu_Class')){
				$vw_photography_plugin_custom_css ='display: block';
			}
		?>
		<div id="lite_theme" class="tabcontent open">
			<?php if(!class_exists('Ibtana_Visual_Editor_Menu_Class')){ 
				$plugin_ins = VW_Photography_Plugin_Activation_Settings::get_instance();
				$vw_photography_actions = $plugin_ins->recommended_actions;
				?>
				<div class="vw-photography-recommended-plugins">
				    <div class="vw-photography-action-list">
				        <?php if ($vw_photography_actions): foreach ($vw_photography_actions as $key => $vw_photography_actionValue): ?>
				                <div class="vw-photography-action" id="<?php echo esc_attr($vw_photography_actionValue['id']);?>">
			                        <div class="action-inner">
			                            <h3 class="action-title"><?php echo esc_html($vw_photography_actionValue['title']); ?></h3>
			                            <div class="action-desc"><?php echo esc_html($vw_photography_actionValue['desc']); ?></div>
			                            <?php echo wp_kses_post($vw_photography_actionValue['link']); ?>
			                            <a class="ibtana-skip-btn" get-start-tab-id="lite-theme-tab" href="javascript:void(0);"><?php esc_html_e('Skip','vw-photography'); ?></a>
			                        </div>
				                </div>
				            <?php endforeach;
				        endif; ?>
				    </div>
				</div>
			<?php } ?>
			<div class="lite-theme-tab" style="<?php echo esc_attr($vw_photography_plugin_custom_css); ?>">
				<h3><?php esc_html_e( 'Lite Theme Information', 'vw-photography' ); ?></h3>
				<hr class="h3hr">
			  	<p><?php esc_html_e('VW Photography is a mesmerising, well-structured, modern and bold WordPress photography theme for photographers, photo studios, wildlife and wedding photographers, portfolios, graphic designers, space decorators, magazines and event decorators. Its versatility let it to be used by bloggers who have food blog, travel and adventure blog, fashion and lifestyle blog and many other types of blogs where images play a vital role in attracting visitors. The theme has immense space to let your creativity flow all over your website. It is responsive, cross-browser compatible, multilingual, SEO ready and supports RTL writing. Banners and large sliders are used to decorate the space and grab some eyeballs. It is embedded with social media icons to reach maximum target audience. It is built on Bootstrap framework and coded from scratch to give a strong base to the website. VW Photography can be deeply customized to give personalized look and feel to it. It presents plethora of options to style the header, footer and sidebars with multiple layouts. It has clean and secure coding maintaining WordPress standards to ensure a bug-free website.','vw-photography'); ?></p>
			  	<div class="col-left-inner">
			  		<h4><?php esc_html_e( 'Theme Documentation', 'vw-photography' ); ?></h4>
					<p><?php esc_html_e( 'If you need any assistance regarding setting up and configuring the Theme, our documentation is there.', 'vw-photography' ); ?></p>
					<div class="info-link">
						<a href="<?php echo esc_url( VW_PHOTOGRAPHY_FREE_THEME_DOC ); ?>" target="_blank"> <?php esc_html_e( 'Documentation', 'vw-photography' ); ?></a>
					</div>
					<hr>
					<h4><?php esc_html_e('Theme Customizer', 'vw-photography'); ?></h4>
					<p> <?php esc_html_e('To begin customizing your website, start by clicking "Customize".', 'vw-photography'); ?></p>
					<div class="info-link">
						<a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e('Customizing', 'vw-photography'); ?></a>
					</div>
					<hr>				
					<h4><?php esc_html_e('Having Trouble, Need Support?', 'vw-photography'); ?></h4>
					<p> <?php esc_html_e('Our dedicated team is well prepared to help you out in case of queries and doubts regarding our theme.', 'vw-photography'); ?></p>
					<div class="info-link">
						<a href="<?php echo esc_url( VW_PHOTOGRAPHY_SUPPORT ); ?>" target="_blank"><?php esc_html_e('Support Forum', 'vw-photography'); ?></a>
					</div>
					<hr>
					<h4><?php esc_html_e('Reviews & Testimonials', 'vw-photography'); ?></h4>
					<p> <?php esc_html_e('All the features and aspects of this WordPress Theme are phenomenal. I\'d recommend this theme to all.', 'vw-photography'); ?>  </p>
					<div class="info-link">
						<a href="<?php echo esc_url( VW_PHOTOGRAPHY_REVIEW ); ?>" target="_blank"><?php esc_html_e('Reviews', 'vw-photography'); ?></a>
					</div>
			  		<div class="link-customizer">
						<h3><?php esc_html_e( 'Link to customizer', 'vw-photography' ); ?></h3>
						<hr class="h3hr">
						<div class="first-row">
							<div class="row-box">
								<div class="row-box1">
									<span class="dashicons dashicons-buddicons-buddypress-logo"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[control]=custom_logo') ); ?>" target="_blank"><?php esc_html_e('Upload your logo','vw-photography'); ?></a>
								</div>
								<div class="row-box2">
									<span class="dashicons dashicons-slides"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=vw_photography_slidersettings') ); ?>" target="_blank"><?php esc_html_e('Slider Settings','vw-photography'); ?></a>
								</div>
							</div>
							<div class="row-box">
								<div class="row-box1">
									<span class="dashicons dashicons-editor-table"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=vw_photography_category_section') ); ?>" target="_blank"><?php esc_html_e('Photography Section','vw-photography'); ?></a>
								</div>
								<div class="row-box2">
									<span class="dashicons dashicons-menu"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[panel]=nav_menus') ); ?>" target="_blank"><?php esc_html_e('Menus','vw-photography'); ?></a>
								</div>
							</div>

							<div class="row-box">
								<div class="row-box1">
									<span class="dashicons dashicons-format-gallery"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=vw_photography_post_settings') ); ?>" target="_blank"><?php esc_html_e('Post settings','vw-photography'); ?></a>
								</div>
								 <div class="row-box2">
									<span class="dashicons dashicons-align-center"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=vw_photography_woocommerce_section') ); ?>" target="_blank"><?php esc_html_e('WooCommerce Layout','vw-photography'); ?></a>
								</div> 
							</div>

							<div class="row-box">
								<div class="row-box1">
									<span class="dashicons dashicons-screenoptions"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[panel]=widgets') ); ?>" target="_blank"><?php esc_html_e('Footer Widget','vw-photography'); ?></a>
								</div>
								<div class="row-box2">
									<span class="dashicons dashicons-text-page"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=vw_photography_footer') ); ?>" target="_blank"><?php esc_html_e('Footer Text','vw-photography'); ?></a>
								</div>
							</div>
						</div>
					</div>
			  	</div>
				<div class="col-right-inner">
					<h3 class="page-template"><?php esc_html_e('How to set up Home Page Template','vw-photography'); ?></h3>
				  	<hr class="h3hr">
					<p><?php esc_html_e('Follow these instructions to setup Home page.','vw-photography'); ?></p>
	                <ul>
	                  	<p><span class="strong"><?php esc_html_e('1. Create a new page :','vw-photography'); ?></span><?php esc_html_e(' Go to ','vw-photography'); ?>
					  	<b><?php esc_html_e(' Dashboard >> Pages >> Add New Page','vw-photography'); ?></b></p>

	                  	<p><?php esc_html_e('Name it as "Home" then select the template "Custom Home Page".','vw-photography'); ?></p>
	                  	<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getstart/images/home-page-template.png" alt="" />
	                  	<p><span class="strong"><?php esc_html_e('2. Set the front page:','vw-photography'); ?></span><?php esc_html_e(' Go to ','vw-photography'); ?>
					  	<b><?php esc_html_e(' Settings >> Reading ','vw-photography'); ?></b></p>
					  	<p><?php esc_html_e('Select the option of Static Page, now select the page you created to be the homepage, while another page to be your default page.','vw-photography'); ?></p>
	                  	<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getstart/images/set-front-page.png" alt="" />
	                  	<p><?php esc_html_e(' Once you are done with this, then follow the','vw-photography'); ?> <a class="doc-links" href="https://www.vwthemesdemo.com/docs/free-vw-photography/" target="_blank"><?php esc_html_e('Documentation','vw-photography'); ?></a></p>
	                </ul>
			  	</div>
			</div>
		</div>

		<div id="block_pattern" class="tabcontent">
			<?php if(!class_exists('Ibtana_Visual_Editor_Menu_Class')){ 
			$plugin_ins = VW_Photography_Plugin_Activation_Settings::get_instance();
			$vw_photography_actions = $plugin_ins->recommended_actions;
			?>
				<div class="vw-photography-recommended-plugins">
				    <div class="vw-photography-action-list">
				        <?php if ($vw_photography_actions): foreach ($vw_photography_actions as $key => $vw_photography_actionValue): ?>
				                <div class="vw-photography-action" id="<?php echo esc_attr($vw_photography_actionValue['id']);?>">
			                        <div class="action-inner">
			                            <h3 class="action-title"><?php echo esc_html($vw_photography_actionValue['title']); ?></h3>
			                            <div class="action-desc"><?php echo esc_html($vw_photography_actionValue['desc']); ?></div>
			                            <?php echo wp_kses_post($vw_photography_actionValue['link']); ?>
			                            <a class="ibtana-skip-btn" href="javascript:void(0);" get-start-tab-id="gutenberg-editor-tab"><?php esc_html_e('Skip','vw-photography'); ?></a>
			                        </div>
				                </div>
				            <?php endforeach;
				        endif; ?>
				    </div>
				</div>
			<?php } ?>
			<div class="gutenberg-editor-tab" style="<?php echo esc_attr($vw_photography_plugin_custom_css); ?>">
				<div class="block-pattern-img">
				  	<h3><?php esc_html_e( 'Block Patterns', 'vw-photography' ); ?></h3>
					<hr class="h3hr">
					<p><?php esc_html_e('Follow the below instructions to setup Home page with Block Patterns.','vw-photography'); ?></p>
	              	<p><b><?php esc_html_e('Click on Below Add new page button >> Click on "+" Icon >> Click Pattern Tab >> Click on homepage sections >> Publish.','vw-photography'); ?></span></b></p>
	              	<div class="vw-photography-pattern-page">
				    	<a href="javascript:void(0)" class="vw-pattern-page-btn button-primary button"><?php esc_html_e('Add New Page','vw-photography'); ?></a>
				    </div>
	              	<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getstart/images/block-pattern.png" alt="" />	
	            </div>

	            <div class="block-pattern-link-customizer">
	              	<div class="link-customizer-with-block-pattern">
							<h3><?php esc_html_e( 'Link to customizer', 'vw-photography' ); ?></h3>
							<hr class="h3hr">
							<div class="first-row">
								<div class="row-box">
									<div class="row-box1">
										<span class="dashicons dashicons-buddicons-buddypress-logo"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[control]=custom_logo') ); ?>" target="_blank"><?php esc_html_e('Upload your logo','vw-photography'); ?></a>
									</div>
									<div class="row-box2">
										<span class="dashicons dashicons-networking"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=vw_photography_social_icon_settings') ); ?>" target="_blank"><?php esc_html_e('Social Icons','vw-photography'); ?></a>
									</div>
								</div>
								<div class="row-box">
									<div class="row-box1">
										<span class="dashicons dashicons-menu"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[panel]=nav_menus') ); ?>" target="_blank"><?php esc_html_e('Menus','vw-photography'); ?></a>
									</div>
									
									<div class="row-box2">
										<span class="dashicons dashicons-text-page"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=vw_photography_footer') ); ?>" target="_blank"><?php esc_html_e('Footer Text','vw-photography'); ?></a>
									</div>
								</div>

								<div class="row-box">
									<div class="row-box1">
										<span class="dashicons dashicons-format-gallery"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=vw_photography_post_settings') ); ?>" target="_blank"><?php esc_html_e('Post settings','vw-photography'); ?></a>
									</div>
									 <div class="row-box2">
										<span class="dashicons dashicons-align-center"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=vw_photography_woocommerce_section') ); ?>" target="_blank"><?php esc_html_e('WooCommerce Layout','vw-photography'); ?></a>
									</div> 
								</div>
								
								<div class="row-box">
									<div class="row-box1">
										<span class="dashicons dashicons-admin-generic"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=vw_photography_left_right') ); ?>" target="_blank"><?php esc_html_e('General Settings','vw-photography'); ?></a>
									</div>
									 <div class="row-box2">
										<span class="dashicons dashicons-screenoptions"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[panel]=widgets') ); ?>" target="_blank"><?php esc_html_e('Footer Widget','vw-photography'); ?></a>
									</div> 
								</div>
							</div>
					</div>	
				</div>
	        </div>
		</div>

		<div id="gutenberg_editor" class="tabcontent">
			<?php if(!class_exists('Ibtana_Visual_Editor_Menu_Class')){ 
			$plugin_ins = VW_Photography_Plugin_Activation_Settings::get_instance();
			$vw_photography_actions = $plugin_ins->recommended_actions;
			?>
				<div class="vw-photography-recommended-plugins">
				    <div class="vw-photography-action-list">
				        <?php if ($vw_photography_actions): foreach ($vw_photography_actions as $key => $vw_photography_actionValue): ?>
				                <div class="vw-photography-action" id="<?php echo esc_attr($vw_photography_actionValue['id']);?>">
			                        <div class="action-inner plugin-activation-redirect">
			                            <h3 class="action-title"><?php echo esc_html($vw_photography_actionValue['title']); ?></h3>
			                            <div class="action-desc"><?php echo esc_html($vw_photography_actionValue['desc']); ?></div>
			                            <?php echo wp_kses_post($vw_photography_actionValue['link']); ?>
			                        </div>
				                </div>
				            <?php endforeach;
				        endif; ?>
				    </div>
				</div>
			<?php }else{ ?>
				<h3><?php esc_html_e( 'Gutunberg Blocks', 'vw-photography' ); ?></h3>
				<hr class="h3hr">
				<div class="vw-photography-pattern-page">
			    	<a href="<?php echo esc_url( admin_url( 'admin.php?page=ibtana-visual-editor-templates' ) ); ?>" class="vw-pattern-page-btn ibtana-dashboard-page-btn button-primary button"><?php esc_html_e('Ibtana Settings','vw-photography'); ?></a>
			    </div>

			    <div class="link-customizer-with-guternberg-ibtana">
					<h3><?php esc_html_e( 'Link to customizer', 'vw-photography' ); ?></h3>
					<hr class="h3hr">
					<div class="first-row">
						<div class="row-box">
							<div class="row-box1">
								<span class="dashicons dashicons-buddicons-buddypress-logo"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[control]=custom_logo') ); ?>" target="_blank"><?php esc_html_e('Upload your logo','vw-photography'); ?></a>
							</div>
							<div class="row-box2">
								<span class="dashicons dashicons-networking"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=vw_photography_social_icon_settings') ); ?>" target="_blank"><?php esc_html_e('Social Icons','vw-photography'); ?></a>
							</div>
						</div>
						<div class="row-box">
							<div class="row-box1">
								<span class="dashicons dashicons-menu"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[panel]=nav_menus') ); ?>" target="_blank"><?php esc_html_e('Menus','vw-photography'); ?></a>
							</div>
							
							<div class="row-box2">
								<span class="dashicons dashicons-text-page"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=vw_photography_footer') ); ?>" target="_blank"><?php esc_html_e('Footer Text','vw-photography'); ?></a>
							</div>
						</div>

						<div class="row-box">
							<div class="row-box1">
								<span class="dashicons dashicons-format-gallery"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=vw_photography_post_settings') ); ?>" target="_blank"><?php esc_html_e('Post settings','vw-photography'); ?></a>
							</div>
							 <div class="row-box2">
								<span class="dashicons dashicons-align-center"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=vw_photography_woocommerce_section') ); ?>" target="_blank"><?php esc_html_e('WooCommerce Layout','vw-photography'); ?></a>
							</div> 
						</div>
						
						<div class="row-box">
							<div class="row-box1">
								<span class="dashicons dashicons-admin-generic"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=vw_photography_left_right') ); ?>" target="_blank"><?php esc_html_e('General Settings','vw-photography'); ?></a>
							</div>
							 <div class="row-box2">
								<span class="dashicons dashicons-screenoptions"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[panel]=widgets') ); ?>" target="_blank"><?php esc_html_e('Footer Widget','vw-photography'); ?></a>
							</div> 
						</div>
					</div>
				</div>
			<?php } ?>
		</div>

		<div id="theme_pro" class="tabcontent">
		  	<h3><?php esc_html_e( 'Premium Theme Information', 'vw-photography' ); ?></h3>
			<hr class="h3hr">
		    <div class="col-left-pro">
		    	<p><?php esc_html_e('The WordPress photography themes is stylish, charming, engaging, robust and bold with a beautifully designed space to show your art. It is specifically created for photographers, photo studios, graphic designers, event decorators, photo frame shops, printing agency, magazines, travel and photo journalists and similar image-centred website. It can be used by bloggers having food blog or travel and adventure blog, fashion and clothing blog and all those who want to entice their visitors with charming and eye-catching photos and images. Display images in any shape and size such is its flexibility. Colours play a vital role in any photography website and this theme provides unlimited colours to open vast opportunities to choose any colour scheme. This WordPress photography themes gives so many options of blog, pages and template layouts, header and footer styles and sidebar layouts to design the theme that you can never end up with a cliched design.','vw-photography'); ?></p>
		    	<div class="pro-links">
			    	<a href="<?php echo esc_url( VW_PHOTOGRAPHY_LIVE_DEMO ); ?>" target="_blank"><?php esc_html_e('Live Demo', 'vw-photography'); ?></a>
					<a href="<?php echo esc_url( VW_PHOTOGRAPHY_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Buy Pro', 'vw-photography'); ?></a>
					<a href="<?php echo esc_url( VW_PHOTOGRAPHY_PRO_DOC ); ?>" target="_blank"><?php esc_html_e('Pro Documentation', 'vw-photography'); ?></a>
				</div>
		    </div>
		    <div class="col-right-pro">
		    	<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getstart/images/responsive.png" alt="" />
		    </div>
		    <div class="featurebox">
			    <h3><?php esc_html_e( 'Theme Features', 'vw-photography' ); ?></h3>
				<hr class="h3hr">
				<div class="table-image">
					<table class="tablebox">
						<thead>
							<tr>
								<th></th>
								<th><?php esc_html_e('Free Themes', 'vw-photography'); ?></th>
								<th><?php esc_html_e('Premium Themes', 'vw-photography'); ?></th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td><?php esc_html_e('Theme Customization', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Responsive Design', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Logo Upload', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Social Media Links', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Slider Settings', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Number of Slides', 'vw-photography'); ?></td>
								<td class="table-img"><?php esc_html_e('4', 'vw-photography'); ?></td>
								<td class="table-img"><?php esc_html_e('Unlimited', 'vw-photography'); ?></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Template Pages', 'vw-photography'); ?></td>
								<td class="table-img"><?php esc_html_e('3', 'vw-photography'); ?></td>
								<td class="table-img"><?php esc_html_e('6', 'vw-photography'); ?></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Home Page Template', 'vw-photography'); ?></td>
								<td class="table-img"><?php esc_html_e('1', 'vw-photography'); ?></td>
								<td class="table-img"><?php esc_html_e('1', 'vw-photography'); ?></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Theme sections', 'vw-photography'); ?></td>
								<td class="table-img"><?php esc_html_e('2', 'vw-photography'); ?></td>
								<td class="table-img"><?php esc_html_e('15', 'vw-photography'); ?></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Contact us Page Template', 'vw-photography'); ?></td>
								<td class="table-img">0</td>
								<td class="table-img"><?php esc_html_e('1', 'vw-photography'); ?></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Blog Templates & Layout', 'vw-photography'); ?></td>
								<td class="table-img">0</td>
								<td class="table-img"><?php esc_html_e('3(Full width/Left/Right Sidebar)', 'vw-photography'); ?></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Page Templates & Layout', 'vw-photography'); ?></td>
								<td class="table-img">0</td>
								<td class="table-img"><?php esc_html_e('2(Left/Right Sidebar)', 'vw-photography'); ?></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Color Pallete For Particular Sections', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-times"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Global Color Option', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Section Reordering', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-times"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Demo Importer', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-times"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Allow To Set Site Title, Tagline, Logo', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-times"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Enable Disable Options On All Sections, Logo', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-times"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Full Documentation', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Latest WordPress Compatibility', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Woo-Commerce Compatibility', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Support 3rd Party Plugins', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Secure and Optimized Code', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Exclusive Functionalities', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-times"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Section Enable / Disable', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-times"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Section Google Font Choices', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-times"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Gallery', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-times"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Simple & Mega Menu Option', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-times"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Support to add custom CSS / JS ', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-times"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Shortcodes', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-times"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Custom Background, Colors, Header, Logo & Menu', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-times"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Premium Membership', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-times"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Budget Friendly Value', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-times"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Priority Error Fixing', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-times"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Custom Feature Addition', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-times"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('All Access Theme Pass', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-times"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Seamless Customer Support', 'vw-photography'); ?></td>
								<td class="table-img"><i class="fas fa-times"></i></td>
								<td class="table-img"><i class="fas fa-check"></i></td>
							</tr>
							<tr>
								<td></td>
								<td class="table-img"></td>
								<td class="update-link"><a href="<?php echo esc_url( VW_PHOTOGRAPHY_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Upgrade to Pro', 'vw-photography'); ?></a></td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
		</div>

		<div id="free_pro" class="tabcontent">
		  	<div class="col-3">
		  		<h4><span class="dashicons dashicons-star-filled"></span><?php esc_html_e('Pro Version', 'vw-photography'); ?></h4>
				<p> <?php esc_html_e('To gain access to extra theme options and more interesting features, upgrade to pro version.', 'vw-photography'); ?></p>
				<div class="info-link">
					<a href="<?php echo esc_url( VW_PHOTOGRAPHY_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Get Pro', 'vw-photography'); ?></a>
				</div>
		  	</div>
		  	<div class="col-3">
		  		<h4><span class="dashicons dashicons-cart"></span><?php esc_html_e('Pre-purchase Queries', 'vw-photography'); ?></h4>
				<p> <?php esc_html_e('If you have any pre-sale query, we are prepared to resolve it.', 'vw-photography'); ?></p>
				<div class="info-link">
					<a href="<?php echo esc_url( VW_PHOTOGRAPHY_CONTACT ); ?>" target="_blank"><?php esc_html_e('Question', 'vw-photography'); ?></a>
				</div>
		  	</div>
		  	<div class="col-3">		  		
		  		<h4><span class="dashicons dashicons-admin-customizer"></span><?php esc_html_e('Child Theme', 'vw-photography'); ?></h4>
				<p> <?php esc_html_e('For theme file customizations, make modifications in the child theme and not in the main theme file.', 'vw-photography'); ?></p>
				<div class="info-link">
					<a href="<?php echo esc_url( VW_PHOTOGRAPHY_CHILD_THEME ); ?>" target="_blank"><?php esc_html_e('About Child Theme', 'vw-photography'); ?></a>
				</div>
		  	</div>

		  	<div class="col-3">
		  		<h4><span class="dashicons dashicons-admin-comments"></span><?php esc_html_e('Frequently Asked Questions', 'vw-photography'); ?></h4>
				<p> <?php esc_html_e('We have gathered top most, frequently asked questions and answered them for your easy understanding. We will list down more as we get new challenging queries. Check back often.', 'vw-photography'); ?></p>
				<div class="info-link">
					<a href="<?php echo esc_url( VW_PHOTOGRAPHY_FAQ ); ?>" target="_blank"><?php esc_html_e('View FAQ','vw-photography'); ?></a>
				</div>
		  	</div>

		  	<div class="col-3">
		  		<h4><span class="dashicons dashicons-sos"></span><?php esc_html_e('Support Queries', 'vw-photography'); ?></h4>
				<p> <?php esc_html_e('If you have any queries after purchase, you can contact us. We are eveready to help you out.', 'vw-photography'); ?></p>
				<div class="info-link">
					<a href="<?php echo esc_url( VW_PHOTOGRAPHY_SUPPORT ); ?>" target="_blank"><?php esc_html_e('Contact Us', 'vw-photography'); ?></a>
				</div>
		  	</div>
		</div>
	</div>
</div>
<?php } ?>