<?php
/**
 * VW Photography Theme Customizer
 *
 * @package VW Photography
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function vw_photography_custom_controls() {

    load_template( trailingslashit( get_template_directory() ) . '/inc/custom-controls.php' );
}
add_action( 'customize_register', 'vw_photography_custom_controls' );

function vw_photography_customize_register( $wp_customize ) {

	load_template( trailingslashit( get_template_directory() ) . '/inc/icon-picker.php' );

	$wp_customize->get_setting( 'blogname' )->transport = 'postMessage'; 
	$wp_customize->get_setting( 'blogdescription' )->transport = 'postMessage';

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial( 'blogname', array( 
		'selector' => '.logo .site-title a', 
	 	'render_callback' => 'vw_photography_customize_partial_blogname', 
	)); 

	$wp_customize->selective_refresh->add_partial( 'blogdescription', array( 
		'selector' => 'p.site-description', 
		'render_callback' => 'vw_photography_customize_partial_blogdescription', 
	));

	//add home page setting pannel
	$VWPhotographyParentPanel = new VW_Photography_WP_Customize_Panel( $wp_customize, 'vw_photography_panel_id', array(
		'capability' => 'edit_theme_options',
		'theme_supports' => '',
		'title' => esc_html__( 'VW Settings', 'vw-photography' ),
		'priority' => 10,
	));

	$wp_customize->add_section( 'vw_photography_left_right', array(
    	'title'      => esc_html__( 'General Settings', 'vw-photography' ),
		'panel' => 'vw_photography_panel_id'
	) );

	$wp_customize->add_setting('vw_photography_width_option',array(
        'default' => 'Full Width',
        'sanitize_callback' => 'vw_photography_sanitize_choices'
	));
	$wp_customize->add_control(new VW_Photography_Image_Radio_Control($wp_customize, 'vw_photography_width_option', array(
        'type' => 'select',
        'label' => __('Width Layouts','vw-photography'),
        'description' => __('Here you can change the width layout of Website.','vw-photography'),
        'section' => 'vw_photography_left_right',
        'choices' => array(
            'Full Width' => esc_url(get_template_directory_uri()).'/images/full-width.png',
            'Wide Width' => esc_url(get_template_directory_uri()).'/images/wide-width.png',
            'Boxed' => esc_url(get_template_directory_uri()).'/images/boxed-width.png',
    ))));

	// Add Settings and Controls for Layout
	$wp_customize->add_setting('vw_photography_theme_options',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'vw_photography_sanitize_choices'	        
	) );
	$wp_customize->add_control('vw_photography_theme_options', array(
        'type' => 'select',
        'label' => __('Post Sidebar Layout','vw-photography'),
        'description' => __('Here you can change the sidebar layout for posts. ','vw-photography'),
        'section' => 'vw_photography_left_right',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','vw-photography'),
            'Right Sidebar' => __('Right Sidebar','vw-photography'),
            'One Column' => __('One Column','vw-photography'),
            'Three Columns' => __('Three Columns','vw-photography'),
            'Four Columns' => __('Four Columns','vw-photography'),
            'Grid Layout' => __('Grid Layout','vw-photography')
        ),
	));

	$wp_customize->add_setting('vw_photography_page_layout',array(
        'default' => 'One Column',
        'sanitize_callback' => 'vw_photography_sanitize_choices'
	));
	$wp_customize->add_control('vw_photography_page_layout',array(
        'type' => 'select',
        'label' => __('Page Sidebar Layout','vw-photography'),
        'description' => __('Here you can change the sidebar layout for pages. ','vw-photography'),
        'section' => 'vw_photography_left_right',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','vw-photography'),
            'Right Sidebar' => __('Right Sidebar','vw-photography'),
            'One Column' => __('One Column','vw-photography')
        ),
	) );

	//Sticky Header
	$wp_customize->add_setting( 'vw_photography_sticky_header',array(
        'default' => 0,
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_photography_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Photography_Toggle_Switch_Custom_Control( $wp_customize, 'vw_photography_sticky_header',array(
        'label' => esc_html__( 'Sticky Header','vw-photography' ),
        'section' => 'vw_photography_left_right'
    )));

    $wp_customize->add_setting('vw_photography_sticky_header_padding',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_photography_sticky_header_padding',array(
		'label'	=> __('Sticky Header Padding','vw-photography'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-photography'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-photography' ),
        ),
		'section'=> 'vw_photography_left_right',
		'type'=> 'text'
	));

    //Selective Refresh
	$wp_customize->selective_refresh->add_partial('vw_photography_search_hide_show', array( 
		'selector' => '.search-box i', 
		'render_callback' => 'vw_photography_customize_partial_vw_photography_search_hide_show', 
	));

	$wp_customize->add_setting( 'vw_photography_search_hide_show', array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_photography_switch_sanitization'
    ));  
    $wp_customize->add_control( new VW_Photography_Toggle_Switch_Custom_Control( $wp_customize, 'vw_photography_search_hide_show',
       array(
		'label' => esc_html__( 'Show / Hide Search','vw-photography' ),
		'section' => 'vw_photography_left_right'
    )));

    $wp_customize->add_setting('vw_photography_search_icon',array(
		'default'	=> 'fas fa-search',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new VW_Photography_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_photography_search_icon',array(
		'label'	=> __('Add Search Icon','vw-photography'),
		'transport' => 'refresh',
		'section'	=> 'vw_photography_left_right',
		'setting'	=> 'vw_photography_search_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('vw_photography_search_close_icon',array(
		'default'	=> 'fa fa-window-close',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new VW_Photography_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_photography_search_close_icon',array(
		'label'	=> __('Add Search Close Icon','vw-photography'),
		'transport' => 'refresh',
		'section'	=> 'vw_photography_left_right',
		'setting'	=> 'vw_photography_search_close_icon',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting('vw_photography_search_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_photography_search_font_size',array(
		'label'	=> __('Search Font Size','vw-photography'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-photography'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-photography' ),
        ),
		'section'=> 'vw_photography_left_right',
		'type'=> 'text'
	));

	//Pre-Loader
	$wp_customize->add_setting( 'vw_photography_loader_enable',array(
        'default' => 0,
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_photography_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Photography_Toggle_Switch_Custom_Control( $wp_customize, 'vw_photography_loader_enable',array(
        'label' => esc_html__( 'Pre-Loader','vw-photography' ),
        'section' => 'vw_photography_left_right'
    )));

	$wp_customize->add_setting('vw_photography_preloader_bg_color', array(
		'default'           => '#e381b0',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'vw_photography_preloader_bg_color', array(
		'label'    => __('Pre-Loader Background Color', 'vw-photography'),
		'section'  => 'vw_photography_left_right',
	)));

	$wp_customize->add_setting('vw_photography_preloader_border_color', array(
		'default'           => '#ffffff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'vw_photography_preloader_border_color', array(
		'label'    => __('Pre-Loader Border Color', 'vw-photography'),
		'section'  => 'vw_photography_left_right',
	)));

	//Slider
	$wp_customize->add_section( 'vw_photography_slidersettings' , array(
    	'title'      => __( 'Slider Settings', 'vw-photography' ),
		'priority'   => null,
		'panel' => 'vw_photography_panel_id'
	) );

	$wp_customize->add_setting( 'vw_photography_slider_hide_show',
       array(
      'default' => 0,
      'transport' => 'refresh',
      'sanitize_callback' => 'vw_photography_switch_sanitization'
    ));  
    $wp_customize->add_control( new VW_Photography_Toggle_Switch_Custom_Control( $wp_customize, 'vw_photography_slider_hide_show',
       array(
      'label' => esc_html__( 'Show / Hide Slider','vw-photography' ),
      'section' => 'vw_photography_slidersettings'
    )));

    //Selective Refresh
    $wp_customize->selective_refresh->add_partial('vw_photography_slider_hide_show',array(
		'selector'        => '#slider .inner_carousel h1',
		'render_callback' => 'vw_photography_customize_partial_vw_photography_slider_hide_show',
	));

	for ( $count = 1; $count <= 4; $count++ ) {
		// Add color scheme setting and control.
		$wp_customize->add_setting( 'vw_photography_slider_page' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'vw_photography_sanitize_dropdown_pages'
		) );
		$wp_customize->add_control( 'vw_photography_slider_page' . $count, array(
			'label'    => __( 'Select Slide Image Page', 'vw-photography' ),
			'description' => __('Slider image size (1500 x 600)','vw-photography'),
			'section'  => 'vw_photography_slidersettings',
			'type'     => 'dropdown-pages'
		) );
	}

	$wp_customize->add_setting('vw_photography_slider_button_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_photography_slider_button_text',array(
		'label'	=> __('Add Slider Button Text','vw-photography'),
		'input_attrs' => array(
            'placeholder' => __( 'READ MORE', 'vw-photography' ),
        ),
		'section'=> 'vw_photography_slidersettings',
		'type'=> 'text'
	));

	//content layout
	$wp_customize->add_setting('vw_photography_slider_content_option',array(
        'default' => 'Center',
        'sanitize_callback' => 'vw_photography_sanitize_choices'
	));
	$wp_customize->add_control(new VW_Photography_Image_Radio_Control($wp_customize, 'vw_photography_slider_content_option', array(
        'type' => 'select',
        'label' => __('Slider Content Layouts','vw-photography'),
        'section' => 'vw_photography_slidersettings',
        'choices' => array(
            'Left' => esc_url(get_template_directory_uri()).'/images/slider-content1.png',
            'Center' => esc_url(get_template_directory_uri()).'/images/slider-content2.png',
            'Right' => esc_url(get_template_directory_uri()).'/images/slider-content3.png',
    ))));

    //Slider excerpt
	$wp_customize->add_setting( 'vw_photography_slider_excerpt_number', array(
		'default'              => 30,
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_photography_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_photography_slider_excerpt_number', array(
		'label'       => esc_html__( 'Slider Excerpt length','vw-photography' ),
		'section'     => 'vw_photography_slidersettings',
		'type'        => 'range',
		'settings'    => 'vw_photography_slider_excerpt_number',
		'input_attrs' => array(
			'step'             => 2,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	//Opacity
	$wp_customize->add_setting('vw_photography_slider_opacity_color',array(
		'default'              => 0.5,
		'sanitize_callback' => 'vw_photography_sanitize_choices'
	));

	$wp_customize->add_control( 'vw_photography_slider_opacity_color', array(
		'label'       => esc_html__( 'Slider Image Opacity','vw-photography' ),
		'section'     => 'vw_photography_slidersettings',
		'type'        => 'select',
		'settings'    => 'vw_photography_slider_opacity_color',
		'choices' => array(
			'0' =>  esc_attr('0','vw-photography'),
			'0.1' =>  esc_attr('0.1','vw-photography'),
			'0.2' =>  esc_attr('0.2','vw-photography'),
			'0.3' =>  esc_attr('0.3','vw-photography'),
			'0.4' =>  esc_attr('0.4','vw-photography'),
			'0.5' =>  esc_attr('0.5','vw-photography'),
			'0.6' =>  esc_attr('0.6','vw-photography'),
			'0.7' =>  esc_attr('0.7','vw-photography'),
			'0.8' =>  esc_attr('0.8','vw-photography'),
			'0.9' =>  esc_attr('0.9','vw-photography')
		),
	));

	//Slider height
	$wp_customize->add_setting('vw_photography_slider_height',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_photography_slider_height',array(
		'label'	=> __('Slider Height','vw-photography'),
		'description'	=> __('Specify the slider height (px).','vw-photography'),
		'input_attrs' => array(
            'placeholder' => __( '500px', 'vw-photography' ),
        ),
		'section'=> 'vw_photography_slidersettings',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'vw_photography_slider_speed', array(
		'default'  => 4000,
		'sanitize_callback'	=> 'vw_photography_sanitize_float'
	) );
	$wp_customize->add_control( 'vw_photography_slider_speed', array(
		'label' => esc_html__('Slider Transition Speed','vw-photography'),
		'section' => 'vw_photography_slidersettings',
		'type'  => 'number',
	) );

	//Photography Category
	$wp_customize->add_section( 'vw_photography_category_section' , array(
    	'title'      => __( 'Photography Category', 'vw-photography' ),
		'priority'   => null,
		'panel' => 'vw_photography_panel_id'
	) );

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial( 'vw_photography_category_page', array( 
		'selector' => '.cat-page-box h2', 
		'render_callback' => 'vw_photography_customize_partial_vw_photography_category_page',
	));

	$wp_customize->add_setting('vw_photography_category_page_icon',array(
		'default'	=> 'fas fa-camera-retro',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new VW_Photography_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_photography_category_page_icon',array(
		'label'	=> __('Add Category Page Icon','vw-photography'),
		'transport' => 'refresh',
		'section'	=> 'vw_photography_category_section',
		'setting'	=> 'vw_photography_category_page_icon',
		'type'		=> 'icon'
	)));

	// Add color scheme setting and control.
	$wp_customize->add_setting( 'vw_photography_category_page', array(
		'default'           => '',
		'sanitize_callback' => 'vw_photography_sanitize_dropdown_pages'
	) );
	$wp_customize->add_control( 'vw_photography_category_page', array(
		'label'    => __( 'Category Page', 'vw-photography' ),
		'section'  => 'vw_photography_category_section',
		'type'     => 'dropdown-pages'
	) );

	$args = array('numberposts' => -1);
	$post_list = get_posts($args);
	$i = 0;
	$pst[]='Select';
	foreach($post_list as $post){
		$pst[$post->post_title] = $post->post_title;
	}

	for ( $m = 1; $m <= 3; $m++ ) {
		$wp_customize->add_setting('vw_photography_post_category' .$m,array(
			'sanitize_callback' => 'vw_photography_sanitize_choices',
		));
		$wp_customize->add_control('vw_photography_post_category' .$m,array(
			'type'    => 'select',
			'choices' => $pst,
			'label' => __('Select post','vw-photography'),
			'description' => __('Image Size (290 x 440)','vw-photography'),
			'section' => 'vw_photography_category_section',
		));
	}

	//Category excerpt
	$wp_customize->add_setting( 'vw_photography_category_excerpt_number', array(
		'default'              => 30,
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_photography_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_photography_category_excerpt_number', array(
		'label'       => esc_html__( 'Category Excerpt length','vw-photography' ),
		'section'     => 'vw_photography_category_section',
		'type'        => 'range',
		'settings'    => 'vw_photography_category_excerpt_number',
		'input_attrs' => array(
			'step'             => 2,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('vw_photography_category_button_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_photography_category_button_text',array(
		'label'	=> __('Add Category Button Text','vw-photography'),
		'input_attrs' => array(
            'placeholder' => __( 'Read More', 'vw-photography' ),
        ),
		'section'=> 'vw_photography_category_section',
		'type'=> 'text'
	));

	//Blog Post
	$wp_customize->add_panel( $VWPhotographyParentPanel );

	$BlogPostParentPanel = new VW_Photography_WP_Customize_Panel( $wp_customize, 'blog_post_parent_panel', array(
		'title' => __( 'Blog Post Settings', 'vw-photography' ),
		'panel' => 'vw_photography_panel_id',
	));

	$wp_customize->add_panel( $BlogPostParentPanel );

	// Add example section and controls to the middle (second) panel
	$wp_customize->add_section( 'vw_photography_post_settings', array(
		'title' => __( 'Post Settings', 'vw-photography' ),
		'panel' => 'blog_post_parent_panel',
	));

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial('vw_photography_toggle_postdate', array( 
		'selector' => '.post-main-box h2 a', 
		'render_callback' => 'vw_photography_customize_partial_vw_photography_toggle_postdate', 
	));

	$wp_customize->add_setting( 'vw_photography_toggle_postdate',array(
        'default' => 1,
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_photography_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Photography_Toggle_Switch_Custom_Control( $wp_customize, 'vw_photography_toggle_postdate',array(
        'label' => esc_html__( 'Post Date','vw-photography' ),
        'section' => 'vw_photography_post_settings'
    )));

    $wp_customize->add_setting( 'vw_photography_toggle_author',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_photography_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Photography_Toggle_Switch_Custom_Control( $wp_customize, 'vw_photography_toggle_author',array(
		'label' => esc_html__( 'Author','vw-photography' ),
		'section' => 'vw_photography_post_settings'
    )));

    $wp_customize->add_setting( 'vw_photography_toggle_comments',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_photography_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Photography_Toggle_Switch_Custom_Control( $wp_customize, 'vw_photography_toggle_comments',array(
		'label' => esc_html__( 'Comments','vw-photography' ),
		'section' => 'vw_photography_post_settings'
    )));

    $wp_customize->add_setting( 'vw_photography_toggle_time',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_photography_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Photography_Toggle_Switch_Custom_Control( $wp_customize, 'vw_photography_toggle_time',array(
		'label' => esc_html__( 'Time','vw-photography' ),
		'section' => 'vw_photography_post_settings'
    )));

    $wp_customize->add_setting( 'vw_photography_featured_image_hide_show',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_photography_switch_sanitization'
	));
    $wp_customize->add_control( new VW_Photography_Toggle_Switch_Custom_Control( $wp_customize, 'vw_photography_featured_image_hide_show', array(
		'label' => esc_html__( 'Featured Image','vw-photography' ),
		'section' => 'vw_photography_post_settings'
    )));

    $wp_customize->add_setting( 'vw_photography_excerpt_number', array(
		'default'              => 30,
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_photography_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_photography_excerpt_number', array(
		'label'       => esc_html__( 'Excerpt length','vw-photography' ),
		'section'     => 'vw_photography_post_settings',
		'type'        => 'range',
		'settings'    => 'vw_photography_excerpt_number',
		'input_attrs' => array(
			'step'             => 2,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('vw_photography_meta_field_separator',array(
		'default'=> '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_photography_meta_field_separator',array(
		'label'	=> __('Add Meta Separator','vw-photography'),
		'description' => __('Add the seperator for meta box. Example: "|", "/", etc.','vw-photography'),
		'section'=> 'vw_photography_post_settings',
		'type'=> 'text'
	));

	//Blog layout
    $wp_customize->add_setting('vw_photography_blog_layout_option',array(
        'default' => 'Default',
        'sanitize_callback' => 'vw_photography_sanitize_choices'
    ));
    $wp_customize->add_control(new VW_Photography_Image_Radio_Control($wp_customize, 'vw_photography_blog_layout_option', array(
        'type' => 'select',
        'label' => __('Blog Layouts','vw-photography'),
        'section' => 'vw_photography_post_settings',
        'choices' => array(
            'Default' => esc_url(get_template_directory_uri()).'/images/blog-layout1.png',
            'Center' => esc_url(get_template_directory_uri()).'/images/blog-layout2.png',
            'Left' => esc_url(get_template_directory_uri()).'/images/blog-layout3.png',
    ))));

    $wp_customize->add_setting('vw_photography_excerpt_settings',array(
        'default' => 'Excerpt',
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_photography_sanitize_choices'
	));
	$wp_customize->add_control('vw_photography_excerpt_settings',array(
        'type' => 'select',
        'label' => __('Post Content','vw-photography'),
        'section' => 'vw_photography_post_settings',
        'choices' => array(
        	'Content' => __('Content','vw-photography'),
            'Excerpt' => __('Excerpt','vw-photography'),
            'No Content' => __('No Content','vw-photography')
        ),
	) );

	$wp_customize->add_setting('vw_photography_excerpt_suffix',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_photography_excerpt_suffix',array(
		'label'	=> __('Add Excerpt Suffix','vw-photography'),
		'input_attrs' => array(
            'placeholder' => __( '[...]', 'vw-photography' ),
        ),
		'section'=> 'vw_photography_post_settings',
		'type'=> 'text'
	));

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial('vw_photography_button_text', array( 
		'selector' => '.post-main-box a.content-bttn', 
		'render_callback' => 'vw_photography_customize_partial_vw_photography_button_text', 
	));

    $wp_customize->add_setting('vw_photography_button_text',array(
		'default'=> esc_html__( 'READ MORE', 'vw-photography' ),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_photography_button_text',array(
		'label'	=> __('Add Button Text','vw-photography'),
		'input_attrs' => array(
            'placeholder' => __( 'READ MORE', 'vw-photography' ),
        ),
		'section'=> 'vw_photography_post_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'vw_photography_blog_pagination_hide_show',array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'vw_photography_switch_sanitization'
    ));  
    $wp_customize->add_control( new VW_Photography_Toggle_Switch_Custom_Control( $wp_customize, 'vw_photography_blog_pagination_hide_show',array(
      'label' => esc_html__( 'Show / Hide Blog Pagination','vw-photography' ),
      'section' => 'vw_photography_post_settings'
    )));

	$wp_customize->add_setting( 'vw_photography_blog_pagination_type', array(
        'default'			=> 'blog-page-numbers',
        'sanitize_callback'	=> 'vw_photography_sanitize_choices'
    ));
    $wp_customize->add_control( 'vw_photography_blog_pagination_type', array(
        'section' => 'vw_photography_post_settings',
        'type' => 'select',
        'label' => __( 'Blog Pagination', 'vw-photography' ),
        'choices'		=> array(
            'blog-page-numbers'  => __( 'Numeric', 'vw-photography' ),
            'next-prev' => __( 'Older Posts/Newer Posts', 'vw-photography' ),
    )));

	// Related Post Settings
	$wp_customize->add_section( 'vw_photography_related_posts_settings', array(
		'title' => __( 'Related Posts Settings', 'vw-photography' ),
		'panel' => 'blog_post_parent_panel',
	));

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial('vw_photography_related_post_title', array( 
		'selector' => '.related-post h3', 
		'render_callback' => 'vw_photography_customize_partial_vw_photography_related_post_title', 
	));

    $wp_customize->add_setting( 'vw_photography_related_post',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_photography_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Photography_Toggle_Switch_Custom_Control( $wp_customize, 'vw_photography_related_post',array(
		'label' => esc_html__( 'Related Post','vw-photography' ),
		'section' => 'vw_photography_related_posts_settings'
    )));

    $wp_customize->add_setting('vw_photography_related_post_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_photography_related_post_title',array(
		'label'	=> __('Add Related Post Title','vw-photography'),
		'input_attrs' => array(
            'placeholder' => __( 'Related Post', 'vw-photography' ),
        ),
		'section'=> 'vw_photography_related_posts_settings',
		'type'=> 'text'
	));

   	$wp_customize->add_setting('vw_photography_related_posts_count',array(
		'default'=> '3',
		'sanitize_callback'	=> 'vw_photography_sanitize_float'
	));
	$wp_customize->add_control('vw_photography_related_posts_count',array(
		'label'	=> __('Add Related Post Count','vw-photography'),
		'input_attrs' => array(
            'placeholder' => __( '3', 'vw-photography' ),
        ),
		'section'=> 'vw_photography_related_posts_settings',
		'type'=> 'number'
	));

	// Single Posts Settings
	$wp_customize->add_section( 'vw_photography_single_blog_settings', array(
		'title' => __( 'Single Post Settings', 'vw-photography' ),
		'panel' => 'blog_post_parent_panel',
	));

	$wp_customize->add_setting( 'vw_photography_toggle_tags',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_photography_switch_sanitization'
	));
    $wp_customize->add_control( new VW_Photography_Toggle_Switch_Custom_Control( $wp_customize, 'vw_photography_toggle_tags', array(
		'label' => esc_html__( 'Tags','vw-photography' ),
		'section' => 'vw_photography_single_blog_settings'
    )));

	$wp_customize->add_setting( 'vw_photography_single_blog_post_navigation_show_hide',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_photography_switch_sanitization'
	));
    $wp_customize->add_control( new VW_Photography_Toggle_Switch_Custom_Control( $wp_customize, 'vw_photography_single_blog_post_navigation_show_hide', array(
		'label' => esc_html__( 'Post Navigation','vw-photography' ),
		'section' => 'vw_photography_single_blog_settings'
    )));

	//navigation text
	$wp_customize->add_setting('vw_photography_single_blog_prev_navigation_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_photography_single_blog_prev_navigation_text',array(
		'label'	=> __('Post Navigation Text','vw-photography'),
		'input_attrs' => array(
            'placeholder' => __( 'PREVIOUS', 'vw-photography' ),
        ),
		'section'=> 'vw_photography_single_blog_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_photography_single_blog_next_navigation_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_photography_single_blog_next_navigation_text',array(
		'label'	=> __('Post Navigation Text','vw-photography'),
		'input_attrs' => array(
            'placeholder' => __( 'NEXT', 'vw-photography' ),
        ),
		'section'=> 'vw_photography_single_blog_settings',
		'type'=> 'text'
	));

    //404 Page Setting
	$wp_customize->add_section('vw_photography_404_page',array(
		'title'	=> __('404 Page Settings','vw-photography'),
		'panel' => 'vw_photography_panel_id',
	));	

	$wp_customize->add_setting('vw_photography_404_page_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('vw_photography_404_page_title',array(
		'label'	=> __('Add Title','vw-photography'),
		'input_attrs' => array(
            'placeholder' => __( '404 Not Found', 'vw-photography' ),
        ),
		'section'=> 'vw_photography_404_page',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_photography_404_page_content',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('vw_photography_404_page_content',array(
		'label'	=> __('Add Text','vw-photography'),
		'input_attrs' => array(
            'placeholder' => __( 'Looks like you have taken a wrong turn, Dont worry, it happens to the best of us.', 'vw-photography' ),
        ),
		'section'=> 'vw_photography_404_page',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_photography_404_page_button_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_photography_404_page_button_text',array(
		'label'	=> __('Add Button Text','vw-photography'),
		'input_attrs' => array(
            'placeholder' => __( 'Return to the home page', 'vw-photography' ),
        ),
		'section'=> 'vw_photography_404_page',
		'type'=> 'text'
	));

	//Social Icon Setting
	$wp_customize->add_section('vw_photography_social_icon_settings',array(
		'title'	=> __('Social Icons Settings','vw-photography'),
		'panel' => 'vw_photography_panel_id',
	));	

	$wp_customize->add_setting('vw_photography_social_icon_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_photography_social_icon_font_size',array(
		'label'	=> __('Icon Font Size','vw-photography'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-photography'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-photography' ),
        ),
		'section'=> 'vw_photography_social_icon_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_photography_social_icon_padding',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_photography_social_icon_padding',array(
		'label'	=> __('Icon Padding','vw-photography'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-photography'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-photography' ),
        ),
		'section'=> 'vw_photography_social_icon_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_photography_social_icon_width',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_photography_social_icon_width',array(
		'label'	=> __('Icon Width','vw-photography'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-photography'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-photography' ),
        ),
		'section'=> 'vw_photography_social_icon_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_photography_social_icon_height',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_photography_social_icon_height',array(
		'label'	=> __('Icon Height','vw-photography'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-photography'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-photography' ),
        ),
		'section'=> 'vw_photography_social_icon_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'vw_photography_social_icon_border_radius', array(
		'default'              => '',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_photography_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_photography_social_icon_border_radius', array(
		'label'       => esc_html__( 'Icon Border Radius','vw-photography' ),
		'section'     => 'vw_photography_social_icon_settings',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	//Responsive Media Settings
	$wp_customize->add_section('vw_photography_responsive_media',array(
		'title'	=> __('Responsive Media','vw-photography'),
		'panel' => 'vw_photography_panel_id',
	));

    $wp_customize->add_setting( 'vw_photography_stickyheader_hide_show',array(
      'default' => 0,
      'transport' => 'refresh',
      'sanitize_callback' => 'vw_photography_switch_sanitization'
    ));  
    $wp_customize->add_control( new VW_Photography_Toggle_Switch_Custom_Control( $wp_customize, 'vw_photography_stickyheader_hide_show',array(
      'label' => esc_html__( 'Sticky Header','vw-photography' ),
      'section' => 'vw_photography_responsive_media'
    )));

    $wp_customize->add_setting( 'vw_photography_resp_slider_hide_show',array(
      'default' => 0,
      'transport' => 'refresh',
      'sanitize_callback' => 'vw_photography_switch_sanitization'
    ));  
    $wp_customize->add_control( new VW_Photography_Toggle_Switch_Custom_Control( $wp_customize, 'vw_photography_resp_slider_hide_show',array(
      'label' => esc_html__( 'Show / Hide Slider','vw-photography' ),
      'section' => 'vw_photography_responsive_media'
    )));

    $wp_customize->add_setting( 'vw_photography_sidebar_hide_show',array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'vw_photography_switch_sanitization'
    ));  
    $wp_customize->add_control( new VW_Photography_Toggle_Switch_Custom_Control( $wp_customize, 'vw_photography_sidebar_hide_show',array(
      'label' => esc_html__( 'Show / Hide Sidebar','vw-photography' ),
      'section' => 'vw_photography_responsive_media'
    )));

    $wp_customize->add_setting( 'vw_photography_resp_scroll_top_hide_show',array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'vw_photography_switch_sanitization'
    ));  
    $wp_customize->add_control( new VW_Photography_Toggle_Switch_Custom_Control( $wp_customize, 'vw_photography_resp_scroll_top_hide_show',array(
      'label' => esc_html__( 'Show / Hide Scroll To Top','vw-photography' ),
      'section' => 'vw_photography_responsive_media'
    )));

     $wp_customize->add_setting('vw_photography_res_menu_open_icon',array(
		'default'	=> 'fas fa-bars',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new VW_Photography_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_photography_res_menu_open_icon',array(
		'label'	=> __('Add Open Menu Icon','vw-photography'),
		'transport' => 'refresh',
		'section'	=> 'vw_photography_responsive_media',
		'setting'	=> 'vw_photography_res_menu_open_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('vw_photography_res_close_menus_icon',array(
		'default'	=> 'fas fa-times',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new VW_Photography_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_photography_res_close_menus_icon',array(
		'label'	=> __('Add Close Menu Icon','vw-photography'),
		'transport' => 'refresh',
		'section'	=> 'vw_photography_responsive_media',
		'setting'	=> 'vw_photography_res_close_menus_icon',
		'type'		=> 'icon'
	)));

	//Footer Text
	$wp_customize->add_section('vw_photography_footer',array(
		'title'	=> __('Footer','vw-photography'),
		'description'=> __('This section will appear in the footer','vw-photography'),
		'panel' => 'vw_photography_panel_id',
	));	

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial('vw_photography_footer_text', array( 
		'selector' => '.copyright p', 
		'render_callback' => 'vw_photography_customize_partial_vw_photography_footer_text', 
	));
	
	$wp_customize->add_setting('vw_photography_footer_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('vw_photography_footer_text',array(
		'label'	=> __('Copyright Text','vw-photography'),
		'section'=> 'vw_photography_footer',
		'setting'=> 'vw_photography_footer_text',
		'type'=> 'text'
	));	

	$wp_customize->add_setting('vw_photography_copyright_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_photography_copyright_font_size',array(
		'label'	=> __('Copyright Font Size','vw-photography'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-photography'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-photography' ),
        ),
		'section'=> 'vw_photography_footer',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_photography_copyright_padding_top_bottom',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_photography_copyright_padding_top_bottom',array(
		'label'	=> __('Copyright Padding Top Bottom','vw-photography'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-photography'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-photography' ),
        ),
		'section'=> 'vw_photography_footer',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_photography_copyright_alignment',array(
        'default' => 'center',
        'sanitize_callback' => 'vw_photography_sanitize_choices'
	));
	$wp_customize->add_control(new VW_Photography_Image_Radio_Control($wp_customize, 'vw_photography_copyright_alignment', array(
        'type' => 'select',
        'label' => __('Copyright Alignment','vw-photography'),
        'section' => 'vw_photography_footer',
        'settings' => 'vw_photography_copyright_alignment',
        'choices' => array(
            'left' => esc_url(get_template_directory_uri()).'/images/copyright1.png',
            'center' => esc_url(get_template_directory_uri()).'/images/copyright2.png',
            'right' => esc_url(get_template_directory_uri()).'/images/copyright3.png'
    ))));

	$wp_customize->add_setting( 'vw_photography_hide_show_scroll',array(
    	'default' => 1,
      	'transport' => 'refresh',
      	'sanitize_callback' => 'vw_photography_switch_sanitization'
    ));  
    $wp_customize->add_control( new VW_Photography_Toggle_Switch_Custom_Control( $wp_customize, 'vw_photography_hide_show_scroll',array(
      	'label' => esc_html__( 'Show / Hide Scroll To Top','vw-photography' ),
      	'section' => 'vw_photography_footer'
    )));

    //Selective Refresh
	$wp_customize->selective_refresh->add_partial('vw_photography_scroll_to_top_icon', array( 
		'selector' => '.scrollup i', 
		'render_callback' => 'vw_photography_customize_partial_vw_photography_scroll_to_top_icon', 
	));

    $wp_customize->add_setting('vw_photography_scroll_to_top_icon',array(
		'default'	=> 'fas fa-long-arrow-alt-up',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new VW_Photography_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_photography_scroll_to_top_icon',array(
		'label'	=> __('Add Scroll to Top Icon','vw-photography'),
		'transport' => 'refresh',
		'section'	=> 'vw_photography_footer',
		'setting'	=> 'vw_photography_scroll_to_top_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('vw_photography_scroll_to_top_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_photography_scroll_to_top_font_size',array(
		'label'	=> __('Icon Font Size','vw-photography'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-photography'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-photography' ),
        ),
		'section'=> 'vw_photography_footer',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_photography_scroll_to_top_padding',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_photography_scroll_to_top_padding',array(
		'label'	=> __('Icon Top Bottom Padding','vw-photography'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-photography'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-photography' ),
        ),
		'section'=> 'vw_photography_footer',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_photography_scroll_to_top_width',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_photography_scroll_to_top_width',array(
		'label'	=> __('Icon Width','vw-photography'),
		'description'	=> __('Enter a value in pixels Example:20px','vw-photography'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-photography' ),
        ),
		'section'=> 'vw_photography_footer',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_photography_scroll_to_top_height',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_photography_scroll_to_top_height',array(
		'label'	=> __('Icon Height','vw-photography'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-photography'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-photography' ),
        ),
		'section'=> 'vw_photography_footer',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'vw_photography_scroll_to_top_border_radius', array(
		'default'              => '',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_photography_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_photography_scroll_to_top_border_radius', array(
		'label'       => esc_html__( 'Icon Border Radius','vw-photography' ),
		'section'     => 'vw_photography_footer',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('vw_photography_scroll_top_alignment',array(
        'default' => 'Right',
        'sanitize_callback' => 'vw_photography_sanitize_choices'
	));
	$wp_customize->add_control(new VW_Photography_Image_Radio_Control($wp_customize, 'vw_photography_scroll_top_alignment', array(
        'type' => 'select',
        'label' => __('Scroll To Top','vw-photography'),
        'section' => 'vw_photography_footer',
        'settings' => 'vw_photography_scroll_top_alignment',
        'choices' => array(
            'Left' => esc_url(get_template_directory_uri()).'/images/layout1.png',
            'Center' => esc_url(get_template_directory_uri()).'/images/layout2.png',
            'Right' => esc_url(get_template_directory_uri()).'/images/layout3.png'
    ))));

    //Woocommerce settings
	$wp_customize->add_section('vw_photography_woocommerce_section', array(
		'title'    => __('WooCommerce Layout', 'vw-photography'),
		'priority' => null,
		'panel'    => 'woocommerce',
	));

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial( 'vw_photography_woocommerce_shop_page_sidebar', array( 'selector' => '.post-type-archive-product #sidebar', 
		'render_callback' => 'vw_photography_customize_partial_vw_photography_woocommerce_shop_page_sidebar', ) );

    //Woocommerce Shop Page Sidebar
	$wp_customize->add_setting( 'vw_photography_woocommerce_shop_page_sidebar',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_photography_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Photography_Toggle_Switch_Custom_Control( $wp_customize, 'vw_photography_woocommerce_shop_page_sidebar',array(
		'label' => esc_html__( 'Shop Page Sidebar','vw-photography' ),
		'section' => 'vw_photography_woocommerce_section'
    )));

    //Selective Refresh
	$wp_customize->selective_refresh->add_partial( 'vw_photography_woocommerce_single_product_page_sidebar', array( 'selector' => '.single-product #sidebar', 
		'render_callback' => 'vw_photography_customize_partial_vw_photography_woocommerce_single_product_page_sidebar', ) );

    //Woocommerce Single Product page Sidebar
	$wp_customize->add_setting( 'vw_photography_woocommerce_single_product_page_sidebar',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_photography_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Photography_Toggle_Switch_Custom_Control( $wp_customize, 'vw_photography_woocommerce_single_product_page_sidebar',array(
		'label' => esc_html__( 'Single Product Sidebar','vw-photography' ),
		'section' => 'vw_photography_woocommerce_section'
    )));

    //Products per page
    $wp_customize->add_setting('vw_photography_products_per_page',array(
		'default'=> 9,
		'sanitize_callback'	=> 'vw_photography_sanitize_float'
	));
	$wp_customize->add_control('vw_photography_products_per_page',array(
		'label'	=> __('Products Per Page','vw-photography'),
		'description' => __('Display on shop page','vw-photography'),
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
		'section'=> 'vw_photography_woocommerce_section',
		'type'=> 'number',
	));

    //Products per row
    $wp_customize->add_setting('vw_photography_products_per_row',array(
		'default'=> 3,
		'sanitize_callback'	=> 'vw_photography_sanitize_choices'
	));
	$wp_customize->add_control('vw_photography_products_per_row',array(
		'label'	=> __('Products Per Row','vw-photography'),
		'description' => __('Display on shop page','vw-photography'),
		'choices' => array(
            2 => 2,
			3 => 3,
			4 => 4,
        ),
		'section'=> 'vw_photography_woocommerce_section',
		'type'=> 'select',
	));

	//Products padding
	$wp_customize->add_setting('vw_photography_products_padding_top_bottom',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_photography_products_padding_top_bottom',array(
		'label'	=> __('Products Padding Top Bottom','vw-photography'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-photography'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-photography' ),
        ),
		'section'=> 'vw_photography_woocommerce_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_photography_products_padding_left_right',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_photography_products_padding_left_right',array(
		'label'	=> __('Products Padding Left Right','vw-photography'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-photography'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-photography' ),
        ),
		'section'=> 'vw_photography_woocommerce_section',
		'type'=> 'text'
	));

	//Products box shadow
	$wp_customize->add_setting( 'vw_photography_products_box_shadow', array(
		'default'              => '',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_photography_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_photography_products_box_shadow', array(
		'label'       => esc_html__( 'Products Box Shadow','vw-photography' ),
		'section'     => 'vw_photography_woocommerce_section',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	//Products border radius
    $wp_customize->add_setting( 'vw_photography_products_border_radius', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_photography_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_photography_products_border_radius', array(
		'label'       => esc_html__( 'Products Border Radius','vw-photography' ),
		'section'     => 'vw_photography_woocommerce_section',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting( 'vw_photography_products_button_border_radius', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_photography_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_photography_products_button_border_radius', array(
		'label'       => esc_html__( 'Products Button Border Radius','vw-photography' ),
		'section'     => 'vw_photography_woocommerce_section',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('vw_photography_woocommerce_sale_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_photography_woocommerce_sale_font_size',array(
		'label'	=> __('Sale Font Size','vw-photography'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-photography'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-photography' ),
        ),
		'section'=> 'vw_photography_woocommerce_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'vw_photography_woocommerce_sale_border_radius', array(
		'default'              => '100',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_photography_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_photography_woocommerce_sale_border_radius', array(
		'label'       => esc_html__( 'Sale Border Radius','vw-photography' ),
		'section'     => 'vw_photography_woocommerce_section',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

    // Has to be at the top
	$wp_customize->register_panel_type( 'VW_Photography_WP_Customize_Panel' );
	$wp_customize->register_section_type( 'VW_Photography_WP_Customize_Section' );
}

add_action( 'customize_register', 'vw_photography_customize_register' );

load_template( trailingslashit( get_template_directory() ) . '/inc/logo/logo-resizer.php' );

if ( class_exists( 'WP_Customize_Panel' ) ) {
  	class VW_Photography_WP_Customize_Panel extends WP_Customize_Panel {
	    public $panel;
	    public $type = 'vw_photography_panel';
	    public function json() {

	      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'type', 'panel', ) );
	      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
	      $array['content'] = $this->get_content();
	      $array['active'] = $this->active();
	      $array['instanceNumber'] = $this->instance_number;
	      return $array;
    	}
  	}
}

if ( class_exists( 'WP_Customize_Section' ) ) {
  	class VW_Photography_WP_Customize_Section extends WP_Customize_Section {
	    public $section;
	    public $type = 'vw_photography_section';
	    public function json() {

	      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'panel', 'type', 'description_hidden', 'section', ) );
	      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
	      $array['content'] = $this->get_content();
	      $array['active'] = $this->active();
	      $array['instanceNumber'] = $this->instance_number;

	      if ( $this->panel ) {
	        $array['customizeAction'] = sprintf( 'Customizing &#9656; %s', esc_html( $this->manager->get_panel( $this->panel )->title ) );
	      } else {
	        $array['customizeAction'] = 'Customizing';
	      }
	      return $array;
    	}
  	}
}

// Enqueue our scripts and styles
function vw_photography_customize_controls_scripts() {
  wp_enqueue_script( 'customizer-controls', get_theme_file_uri( '/js/customizer-controls.js' ), array(), '1.0', true );
}
add_action( 'customize_controls_enqueue_scripts', 'vw_photography_customize_controls_scripts' );

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class VW_Photography_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'VW_Photography_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(new VW_Photography_Customize_Section_Pro($manager,'vw_photography_upgrade_pro_link',array(
			'priority'   => 1,
			'title'    => esc_html__( 'Photography Pro', 'vw-photography' ),
			'pro_text' => esc_html__( 'UPGRADE PRO', 'vw-photography' ),
			'pro_url'  => esc_url('https://www.vwthemes.com/themes/wordpress-photography-themes/'),
		)));

		$manager->add_section(new VW_Photography_Customize_Section_Pro($manager,'vw_photography_get_started_link',array(
			'priority'   => 1,
			'title'    => esc_html__( 'DOCUMENTATION', 'vw-photography' ),
			'pro_text' => esc_html__( 'DOCS', 'vw-photography' ),
			'pro_url'  => admin_url('themes.php?page=vw_photography_guide'),
		)));
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'vw-photography-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'vw-photography-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/css/customize-controls.css' );
	}
}

// Doing this customizer thang!
VW_Photography_Customize::get_instance();