<?php
/**
 * VW Photography: Block Patterns
 *
 * @package VW Photography
 * @since   1.0.0
 */

/**
 * Register Block Pattern Category.
 */
if ( function_exists( 'register_block_pattern_category' ) ) {

	register_block_pattern_category(
		'vw-photography',
		array( 'label' => __( 'VW Photography', 'vw-photography' ) )
	);
}

/**
 * Register Block Patterns.
 */
if ( function_exists( 'register_block_pattern' ) ) {
	register_block_pattern(
		'vw-photography/slider-section',
		array(
			'title'      => __( 'Slider Section', 'vw-photography' ),
			'categories' => array( 'vw-photography' ),
			'content'    => "<!-- wp:cover {\"url\":\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/slider.png\",\"id\":2099,\"customOverlayColor\":\"#30314f\",\"align\":\"full\",\"className\":\"sliderbox\"} -->\n<div class=\"wp-block-cover alignfull has-background-dim sliderbox\" style=\"background-image:url(" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/slider.png);background-color:#30314f\"><div class=\"wp-block-cover__inner-container\"><!-- wp:columns {\"align\":\"full\"} -->\n<div class=\"wp-block-columns alignfull\"><!-- wp:column {\"width\":\"25%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:25%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"50%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:50%\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":1,\"textColor\":\"white\",\"style\":{\"typography\":{\"fontSize\":40}}} -->\n<h1 class=\"has-text-align-center has-white-color has-text-color\" style=\"font-size:40px\">LOREM IPSUM IS SIMPLY DUMMY</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"text-center\",\"style\":{\"typography\":{\"fontSize\":15}}} -->\n<p class=\"has-text-align-center text-center\" style=\"font-size:15px\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever   </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"align\":\"center\"} -->\n<div class=\"wp-block-buttons aligncenter\"><!-- wp:button {\"borderRadius\":30} -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link\" style=\"border-radius:30px\">READ MORE</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"25%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:25%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:cover -->",
		)
	);

	register_block_pattern(
		'vw-photography/category-section',
		array(
			'title'      => __( 'Category Section', 'vw-photography' ),
			'categories' => array( 'vw-photography' ),
			'content'    => "<!-- wp:columns {\"align\":\"wide\",\"className\":\"cat-section mt-5 mx-0\"} -->\n<div class=\"wp-block-columns alignwide cat-section mt-5 mx-0\"><!-- wp:column {\"verticalAlignment\":\"top\",\"className\":\"cat-content\"} -->\n<div class=\"wp-block-column is-vertically-aligned-top cat-content\"><!-- wp:image {\"align\":\"center\",\"id\":2165,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/title.png\" alt=\"\" class=\"wp-image-2165\"/></figure></div>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"className\":\"mb-2\",\"style\":{\"typography\":{\"fontSize\":28}}} -->\n<h2 class=\"has-text-align-center mb-2\" style=\"font-size:28px\">CATEGORIES</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"mb-4 px-3 text-center\",\"style\":{\"typography\":{\"fontSize\":14},\"color\":{\"text\":\"#a9a9b2\"}}} -->\n<p class=\"has-text-align-center mb-4 px-3 text-center has-text-color\" style=\"color:#a9a9b2;font-size:14px\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a<strong> </strong> </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"align\":\"center\"} -->\n<div class=\"wp-block-buttons aligncenter\"><!-- wp:button {\"borderRadius\":0,\"style\":{\"color\":{\"text\":\"#e381b0\"}},\"backgroundColor\":\"white\"} -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-white-background-color has-text-color has-background no-border-radius\" style=\"color:#e381b0\">VIEW ALL CATEGORIES</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"main-post\"} -->\n<div class=\"wp-block-column main-post\"><!-- wp:cover {\"url\":\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/post-1.png\",\"id\":2136,\"align\":\"center\",\"className\":\"post-img\"} -->\n<div class=\"wp-block-cover aligncenter has-background-dim post-img\" style=\"background-image:url(" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/post-1.png)\"><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":3,\"textColor\":\"white\",\"style\":{\"typography\":{\"fontSize\":19}}} -->\n<h3 class=\"has-text-align-left has-white-color has-text-color\" style=\"font-size:19px\">CATEGORY 1</h3>\n<!-- /wp:heading --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:group -->\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container\"><!-- wp:group {\"className\":\"post-content\"} -->\n<div class=\"wp-block-group post-content\"><div class=\"wp-block-group__inner-container\"><!-- wp:heading {\"textAlign\":\"center\",\"className\":\"mt-4 mb-md-3 mb-1\",\"textColor\":\"white\",\"style\":{\"typography\":{\"fontSize\":30}}} -->\n<h2 class=\"has-text-align-center mt-4 mb-md-3 mb-1 has-white-color has-text-color\" style=\"font-size:30px\">CATEGORY 1</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"text-center mb-md-3 mb-1\",\"textColor\":\"white\",\"style\":{\"typography\":{\"fontSize\":17}}} -->\n<p class=\"has-text-align-center text-center mb-md-3 mb-1 has-white-color has-text-color\" style=\"font-size:17px\">1 JAN 2121</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"text-center px-3\",\"textColor\":\"white\",\"style\":{\"typography\":{\"fontSize\":14}}} -->\n<p class=\"has-text-align-center text-center px-3 has-white-color has-text-color\" style=\"font-size:14px\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"align\":\"center\"} -->\n<div class=\"wp-block-buttons aligncenter\"><!-- wp:button {\"borderRadius\":0,\"textColor\":\"black\"} -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-black-color has-text-color no-border-radius\">READ MORE</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"main-post\"} -->\n<div class=\"wp-block-column main-post\"><!-- wp:cover {\"url\":\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/post-2.png\",\"id\":2222,\"align\":\"center\",\"className\":\"post-img\"} -->\n<div class=\"wp-block-cover aligncenter has-background-dim post-img\" style=\"background-image:url(" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/post-2.png)\"><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":3,\"textColor\":\"white\",\"style\":{\"typography\":{\"fontSize\":19}}} -->\n<h3 class=\"has-text-align-left has-white-color has-text-color\" style=\"font-size:19px\">CATEGORY 1</h3>\n<!-- /wp:heading --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:group -->\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container\"><!-- wp:group {\"className\":\"post-content\"} -->\n<div class=\"wp-block-group post-content\"><div class=\"wp-block-group__inner-container\"><!-- wp:heading {\"textAlign\":\"center\",\"className\":\"mt-4 mb-md-3 mb-1\",\"textColor\":\"white\",\"style\":{\"typography\":{\"fontSize\":30}}} -->\n<h2 class=\"has-text-align-center mt-4 mb-md-3 mb-1 has-white-color has-text-color\" style=\"font-size:30px\">CATEGORY 2</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"text-center mb-md-3 mb-1\",\"textColor\":\"white\",\"style\":{\"typography\":{\"fontSize\":17}}} -->\n<p class=\"has-text-align-center text-center mb-md-3 mb-1 has-white-color has-text-color\" style=\"font-size:17px\">1 JAN 2121</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"text-center px-3\",\"textColor\":\"white\",\"style\":{\"typography\":{\"fontSize\":14}}} -->\n<p class=\"has-text-align-center text-center px-3 has-white-color has-text-color\" style=\"font-size:14px\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"align\":\"center\"} -->\n<div class=\"wp-block-buttons aligncenter\"><!-- wp:button {\"borderRadius\":0,\"textColor\":\"black\"} -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-black-color has-text-color no-border-radius\">READ MORE</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"main-post\"} -->\n<div class=\"wp-block-column main-post\"><!-- wp:cover {\"url\":\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/post-3.png\",\"id\":2223,\"align\":\"center\",\"className\":\"post-img\"} -->\n<div class=\"wp-block-cover aligncenter has-background-dim post-img\" style=\"background-image:url(" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/post-3.png)\"><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":3,\"textColor\":\"white\",\"style\":{\"typography\":{\"fontSize\":19}}} -->\n<h3 class=\"has-text-align-left has-white-color has-text-color\" style=\"font-size:19px\">CATEGORY 1</h3>\n<!-- /wp:heading --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:group -->\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container\"><!-- wp:group {\"className\":\"post-content\"} -->\n<div class=\"wp-block-group post-content\"><div class=\"wp-block-group__inner-container\"><!-- wp:heading {\"textAlign\":\"center\",\"className\":\"mt-4 mb-md-3 mb-1\",\"textColor\":\"white\",\"style\":{\"typography\":{\"fontSize\":30}}} -->\n<h2 class=\"has-text-align-center mt-4 mb-md-3 mb-1 has-white-color has-text-color\" style=\"font-size:30px\">CATEGORY 3</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"text-center mb-md-3 mb-1\",\"textColor\":\"white\",\"style\":{\"typography\":{\"fontSize\":17}}} -->\n<p class=\"has-text-align-center text-center mb-md-3 mb-1 has-white-color has-text-color\" style=\"font-size:17px\">1 JAN 2121</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"text-center px-3\",\"textColor\":\"white\",\"style\":{\"typography\":{\"fontSize\":14}}} -->\n<p class=\"has-text-align-center text-center px-3 has-white-color has-text-color\" style=\"font-size:14px\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"align\":\"center\"} -->\n<div class=\"wp-block-buttons aligncenter\"><!-- wp:button {\"borderRadius\":0,\"textColor\":\"black\"} -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-black-color has-text-color no-border-radius\">READ MORE</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->",
		)
	);
}